

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

// Referenced classes of package duggelz.jape:
//            InsetPanel, DataChangeEvent, DataChangeListener, DataChangeMixin,
//            FieldView, ItemDetailPanel, ItemView, Mercenary,
//            Actor

public class ItemPanel extends InsetPanel
    implements DataChangeListener
{

    public ItemPanel(Frame parent)
    {
        super(new Insets(10, 10, 10, 10));
        layout = new GridBagLayout();
        constraint = new GridBagConstraints();
        modified = false;
        views = new Vector();
        mixin = new DataChangeMixin();
        this.parent = parent;
        setLayout(layout);
        constraint.anchor = 16;
        constraint.fill = 0;
        constraint.gridx = 0;
        constraint.gridheight = 1;
        constraint.gridwidth = 1;
        constraint.weightx = 1.0D;
        constraint.insets = new Insets(0, 0, 0, 0);
        newRow();
        addItem(3);
        addSpace();
        addItem(0);
        newRow();
        addItem(4);
        addSpace();
        addItem(1);
        newRow();
        addItem(5);
        addSpace();
        addItem(2);
        newRow();
        addItem(6);
        newRow();
        addItem(11);
        addItem(15);
        addItem(7);
        newRow();
        addItem(12);
        addItem(16);
        addItem(8);
        newRow();
        addItem(13);
        addItem(17);
        addItem(9);
        newRow();
        addItem(14);
        addItem(18);
        addItem(10);
        newRow();
        itemDetailPanel = new ItemDetailPanel(this.parent);
        constraint.gridwidth = 3;
        constraint.weightx = 1.0D;
        constraint.weighty = 1.0D;
        add(itemDetailPanel, constraint);
        itemDetailPanel.addDataChangeListener(this);
    }

    private void addComponent(int colwidth, Component component)
    {
        constraint.gridwidth = colwidth;
        add(component, constraint);
        constraint.gridx += colwidth;
    }

    public void addDataChangeListener(DataChangeListener l)
    {
        mixin.addDataChangeListener(l);
    }

    private void addItem(int index)
    {
        final ItemView view = new ItemView(index);
        addComponent(1, view);
        views.addElement(view);
        view.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e)
            {
                doItemSelected(view);
            }

        });
    }

    private void addSpace()
    {
        constraint.gridx++;
    }

    public void dataChanged(DataChangeEvent event)
    {
        FieldView view = (FieldView)event.getSource();
        String oldValue = event.getOldValue();
        String newValue = event.getNewValue();
        currentView.refresh();
        modified = true;
        fireDataChangeEvent(event);
    }

    public void doItemSelected(ItemView view)
    {
        int index = view.getIndex();
        currentView = view;
        Item item = null;
        if(merc != null)
            item = merc.items[index];
        itemDetailPanel.setItem(item);
    }

    public void fireDataChangeEvent(DataChangeEvent e)
    {
        mixin.fireDataChangeEvent(e);
    }

    public boolean isModified()
    {
        return itemDetailPanel.isModified();
    }

    private void newRow()
    {
        constraint.gridy++;
        constraint.gridx = 0;
    }

    public void removeDataChangeListener(DataChangeListener l)
    {
        mixin.removeDataChangeListener(l);
    }

    public void setActor(Actor actor, Mercenary merc)
    {
        this.actor = actor;
        this.merc = merc;
        for(int idx = 0; idx < views.size(); idx++)
        {
            ItemView view = (ItemView)views.elementAt(idx);
            view.setActor(merc);
        }

        modified = false;
        doItemSelected((ItemView)views.elementAt(0));
    }

    public void setModified(boolean modified)
    {
        itemDetailPanel.setModified(modified);
        this.modified = modified;
    }

    private Frame parent;
    private GridBagLayout layout;
    private GridBagConstraints constraint;
    private ItemDetailPanel itemDetailPanel;
    private boolean modified;
    private Actor actor;
    private Mercenary merc;
    private Vector views;
    private ItemView currentView;
    private DataChangeMixin mixin;
    static final long serialVersionUID = 030265;
}
